﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using Seguridad;
using Dapper;
//using Nova.Libraries;

namespace Nova.Controllers.POA
{
    public class PoaViaticosPasajesReportController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        string query = @"SELECT
f.IdIndicadores 
,MAX(g.ResumenNarrativo) ResumenNarrativo,SUM(a.Dias) Dias ,sum(a.NumeroPersonas) NumeroPersonas
,c.OrigenDestino
,Max(c.Tarifa) Tarifa
,Max(a.ViajeRedondoPersona) ViajeRedondoPersona

,SUM(case when  b.idmes=1 then  (ImporteViaticos) ELSE 0 end ) Enero
,SUM(case when  b.idmes=2 then  (ImporteViaticos) else 0 end)  Febrero
,SUM(case when  b.idmes=3 then  (ImporteViaticos) else 0 end)   Marzo
,SUM(case when  b.idmes=4 then  (ImporteViaticos) else 0 end)   Abril
,SUM(case when  b.idmes=5 then  (ImporteViaticos) else 0 end)   Mayo
,SUM(case when  b.idmes=6 then  (ImporteViaticos) else 0 end)   Junio
,SUM(case when  b.idmes=7 then  (ImporteViaticos) else 0 end)   Julio
,SUM(case when  b.idmes=8 then  (ImporteViaticos) else 0 end)   Agosto
,SUM(case when  b.idmes=9 then  (ImporteViaticos) else 0 end)   Septiembre
,SUM(case when  b.idmes=10 then  (ImporteViaticos) else 0 end)   Octubre
,SUM(case when  b.idmes=11 then  (ImporteViaticos) else 0 end)   Noviembre
,SUM(case when  b.idmes=12 then  (ImporteViaticos) else 0 end)  Diciembre
,SUM(case when (b.idmes)=1 then (NumeroVisitas)  ELSE 0 end ) pEnero
,SUM(case when  b.idmes=2 then  (NumeroVisitas) else 0 end)  pFebrero
,SUM(case when  b.idmes=3 then  (NumeroVisitas) else 0 end)   pMarzo
,SUM(case when  b.idmes=4 then  (NumeroVisitas) else 0 end)   pAbril
,SUM(case when  b.idmes=5 then  (NumeroVisitas) else 0 end)   pMayo
,SUM(case when  b.idmes=6 then  (NumeroVisitas) else 0 end)   pJunio
,SUM(case when  b.idmes=7 then  (NumeroVisitas) else 0 end)   pJulio
,SUM(case when  b.idmes=8 then  (NumeroVisitas) else 0 end)   pAgosto
,SUM(case when  b.idmes=9 then  (NumeroVisitas) else 0 end)   pSeptiembre
,SUM(case when  b.idmes=10 then  (NumeroVisitas) else 0 end)   pOctubre
,SUM(case when  b.idmes=11 then  (NumeroVisitas) else 0 end)   pNoviembre
,SUM(case when  b.idmes=12 then  (NumeroVisitas) else 0 end)  pDiciembre
	
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN 1 ELSE 0 END) as TotalVisitas
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN (a.ImporteViaticos) ELSE 0 END) as ImporteTotalViaticos

,MAX(case when e.TipoPasaje in ('Vehículo oficial') then a.ImporteBoleto else 0 end) ImportePeaje
,SUM(case when e.TipoPasaje in ('Vehículo oficial') then a.TotalPasaje else 0 end) ImporteTotalPeaje

,MAX(case when e.TipoPasaje in ('Vehículo oficial') then 0 else a.ImporteBoleto end) ImporteBoleto
,SUM(case when e.TipoPasaje in ('Vehículo oficial') then 0 else a.TotalPasaje end) TotalPasaje
,e.TipoPasaje, f.PresupuestoCerrado

FROM Poa_ViaticosPasajes a
inner join Poa_Calendario b on a.IdCalendario = b.IdCalendario
inner join Poa_OrigenDestino c on a.IdOrigenDestino = c.IdOrigenDestino
inner join Catalogos_ctMes d on b.IdMes = d.IdMes
inner join Poa_TipoPasaje e on e.IdTipoPasaje = a.IdTipoPasaje

inner join Poa_Indicadores f on f.IdIndicadores = b.IdIndicadores 
inner join Poa_Mir g on g.IdMir = f.IdMir 
inner join Poa_ProyectoArbol h on h.IdProyectoArbol = g.IdProyectoArbol


inner join poa_proyectos i on i.IdProyectos=h.IdProyectos
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria=h.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica=j.IdEstructuraOrganica
where h.Año in @anio
and i.Proyecto in @proyecto
and k.EstructuraOrganica in @area
group by e.TipoPasaje, c.OrigenDestino, f.IdIndicadores, f.PresupuestoCerrado 
order by f.IdIndicadores asc";

        string queryUser = @"SELECT
f.IdIndicadores 
,MAX(g.ResumenNarrativo) ResumenNarrativo,SUM(a.Dias) Dias ,sum(a.NumeroPersonas) NumeroPersonas
,c.OrigenDestino
,Max(c.Tarifa) Tarifa
,Max(a.ViajeRedondoPersona) ViajeRedondoPersona

,SUM(case when  b.idmes=1 then  (ImporteViaticos) ELSE 0 end ) Enero
,SUM(case when  b.idmes=2 then  (ImporteViaticos) else 0 end)  Febrero
,SUM(case when  b.idmes=3 then  (ImporteViaticos) else 0 end)   Marzo
,SUM(case when  b.idmes=4 then  (ImporteViaticos) else 0 end)   Abril
,SUM(case when  b.idmes=5 then  (ImporteViaticos) else 0 end)   Mayo
,SUM(case when  b.idmes=6 then  (ImporteViaticos) else 0 end)   Junio
,SUM(case when  b.idmes=7 then  (ImporteViaticos) else 0 end)   Julio
,SUM(case when  b.idmes=8 then  (ImporteViaticos) else 0 end)   Agosto
,SUM(case when  b.idmes=9 then  (ImporteViaticos) else 0 end)   Septiembre
,SUM(case when  b.idmes=10 then  (ImporteViaticos) else 0 end)   Octubre
,SUM(case when  b.idmes=11 then  (ImporteViaticos) else 0 end)   Noviembre
,SUM(case when  b.idmes=12 then  (ImporteViaticos) else 0 end)  Diciembre
,SUM(case when (b.idmes)=1 then (NumeroVisitas)  ELSE 0 end ) pEnero
,SUM(case when  b.idmes=2 then  (NumeroVisitas) else 0 end)  pFebrero
,SUM(case when  b.idmes=3 then  (NumeroVisitas) else 0 end)   pMarzo
,SUM(case when  b.idmes=4 then  (NumeroVisitas) else 0 end)   pAbril
,SUM(case when  b.idmes=5 then  (NumeroVisitas) else 0 end)   pMayo
,SUM(case when  b.idmes=6 then  (NumeroVisitas) else 0 end)   pJunio
,SUM(case when  b.idmes=7 then  (NumeroVisitas) else 0 end)   pJulio
,SUM(case when  b.idmes=8 then  (NumeroVisitas) else 0 end)   pAgosto
,SUM(case when  b.idmes=9 then  (NumeroVisitas) else 0 end)   pSeptiembre
,SUM(case when  b.idmes=10 then  (NumeroVisitas) else 0 end)   pOctubre
,SUM(case when  b.idmes=11 then  (NumeroVisitas) else 0 end)   pNoviembre
,SUM(case when  b.idmes=12 then  (NumeroVisitas) else 0 end)  pDiciembre
	
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN 1 ELSE 0 END) as TotalVisitas
,sum(CASE WHEN b.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) THEN (a.ImporteViaticos) ELSE 0 END) as ImporteTotalViaticos

,MAX(case when e.TipoPasaje in ('Auto') then a.ImporteBoleto else 0 end) ImportePeaje
,SUM(case when e.TipoPasaje in ('Auto') then a.TotalPasaje else 0 end) ImporteTotalPeaje

,MAX(case when e.TipoPasaje in ('Auto') then 0 else a.ImporteBoleto end) ImporteBoleto
,SUM(case when e.TipoPasaje in ('Auto') then 0 else a.TotalPasaje end) TotalPasaje
,e.TipoPasaje, f.PresupuestoCerrado

FROM Poa_ViaticosPasajes a
inner join Poa_Calendario b on a.IdCalendario = b.IdCalendario
inner join Poa_OrigenDestino c on a.IdOrigenDestino = c.IdOrigenDestino
inner join Catalogos_ctMes d on b.IdMes = d.IdMes
inner join Poa_TipoPasaje e on e.IdTipoPasaje = a.IdTipoPasaje

inner join Poa_Indicadores f on f.IdIndicadores = b.IdIndicadores 
inner join Poa_Mir g on g.IdMir = f.IdMir 
inner join Poa_ProyectoArbol h on h.IdProyectoArbol = g.IdProyectoArbol


inner join poa_proyectos i on i.IdProyectos=h.IdProyectos
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria=h.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica=j.IdEstructuraOrganica
where h.Año in @anio
and i.Proyecto in @proyecto
and k.EstructuraOrganica in @area
and j.IdConvenioLaboralTrabajadorCategoria = @idusuario
group by e.TipoPasaje, c.OrigenDestino, f.IdIndicadores, f.PresupuestoCerrado 
order by f.IdIndicadores asc";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };


        public ActionResult Index()
        {

            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaViaticosPasajesReport");

            }

            return View();
        }


        // GET: PoaViaticosPasajesReport
        public ActionResult Admin()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      Año
  FROM Poa_ProyectoArbol
  group by Año
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by a.IdProyectos desc";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


            string queryAreas = @" select c.EstructuraOrganica 
  from Poa_ProyectoArbol a
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult ViaticosPasajesView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReportViaticosPasajes> result = new List<ReportViaticosPasajes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            return PartialView("_ViaticosPasajes", result);
        }

        public ActionResult ViaticosPasajes(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReportViaticosPasajes> result = new List<ReportViaticosPasajes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            string modalidad = "Poa_ViaticosPasajes" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult ViaticosPasajesXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReportViaticosPasajes> result = new List<ReportViaticosPasajes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ReportViaticosPasajes>)dp.connection.Query<ReportViaticosPasajes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();


            string modalidad = "Poa_ViaticosPasajes_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      Año
  FROM Poa_ProyectoArbol
  group by Año
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }



    }
}